*******************************************************************************
*                         680xx Grundprogramm edit2                           *
*                        (C) 1991 Ralph Dombrowski                            *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                              Editor Teil 2                                  *
*******************************************************************************


curtoend:                       * Endabfrage
 bsr calccur                    * Zeileninfo holen
 move.b curx(a5),d0             * Position holen
 cmp.b (a1),d0                  * Steht Cursor hinter letztem Zeichen
 bcs.s adjcurx1                 * Nein, dann weiter
 cmp.b  #$7f,(a0)               * Leerzeile, dann ganz nach vorne
 bne.s  curtoe0
 move.b lrand(a5),curx(a5)      * Cursor nach vorne
rts
curtoe0:
 cmp.b  #' ',(a2)
 bne.s curtoe1                  * Nicht weiter, wenn kein Leerzeichen gefunden
 subq.l #1,a2                   * Zeichen zurck
 subq.b #1,d0                   * Ein Zeichen weniger
 bpl.s curtoe0
curtoe1:
 addq.l #1,a2
 addq.b #1,d0                   * Angleich
 move.b d0,curx(a5)             * Sonst genau dahinter setzen
 move.b d0,(a1)                 * Zeichenzhler neu
adjcurx:
 cmp.b #80,curx(a5)             * Cursor auf Position 80 ?
 bcs.s adjcurx1                 * Nein, dann weiter
 move.b #79,curx(a5)            * Nur bis 79 ist erlaubt
rts
adjcurx1:
 move.b lrand(a5),d0            * Linker Rand
 cmp.b curx(a5),d0              * Position
 bmi carres                     * Cursor steht dahinter, dann OK
 move.b d0,curx(a5)             * Sonst auf Rand setzen
rts

curright:                       * Cursor um ein Zeichen nach rechts und
 bsr calccur                    * testen, ob Cursur hinter letztem Zeichen
 addq.b #1,curx(a5)
 move.b curx(a5),d0             * oder auf Position 80
 cmp.b (a1),d0                  * Ja, dann Carry = 1
 bhi carset
 cmp.b #80,d0
 beq carset
bra carres                      * Sonst Carry = 0

getscreen:
 bsr clrscreen                  * Bildschirm lschen
 moveq #%11000000, d0           * HELP
 bsr setpage                    * Seite 3 als Schreibseite
 move.l a1, -(a7)               * a1 retten
 lea helptxt0(pc), a1
 lea idebuff(a5), a0            * ausbuf wird schon bentigt
get1scr:
 move.b (a1)+, (a0)+            * helptxt0 nach ausbuf
 bne.s get1scr
 subq.l #1, a0                  * Null raus
 bsr prtvers                    * Versionsnummer nach a0
 movea.l (a7)+, a1
 lea idebuff(a5), a0            * ausbuf wird schon bentigt
 moveq #$22,d0
 move #240,d2
 bsr centertxt                  * berschrift
 lea helptxt1(pc), a0
 moveq #$11, d0
 moveq #0, d1
 move #229, d2
 bsr textprint                  * Erste Spalte
 move #170 ,d1
 lea helptxt2(pc), a0
 bsr textprint                  * Zweite Spalte
 move #340, d1
 lea helptxt3(pc), a0
 bsr textprint                  * Dritte Spalte
 movea.l akttxt(a5), a0         * Von dort an steht Text
 clr d0                         * Von Zeile Null an
getscr0:
 bsr zeispscr                   * Zeile vom Speicher in den Screen-Speicher
 addq #1, d0                    * Nchste Zeile
 cmp #24, d0                    * Bis ganz unten
bne.s getscr0
 bsr.s clrram                   * Ram verschieben
 bsr seite1                     * Seite 1
 bsr setpen                     * Auf Schreiben
 bsr prtall                     * Ausgabe
 bsr seite0                     * Seite 0
 bsr prtall                     * Ausgabe
 move.b lrand(a5), curx(a5)     * Cursor auf linken Rand
bra crtstatus                   * Statuszeile ausgeben

savescreen:                     * Wie putscreen, aber aktuelle Anfangsadresse
 move.l akttxt(a5), -(a7)       * des Bildschirms bleibt erhalten
 bsr.s putscreen                * Screen in Ram bringen
 move.l (a7)+, akttxt(a5)
rts

putscreen:
 moveq #24-1,d1                 * Bildschirm zurck in den Speicher
 moveq #0,d2                    * Zhler der einzufgenden Zeichen
putscr0:
 move d1,d0                     * Zeilennummer
 bsr.s getzlen                  * Lnge ermitteln
 add d0,d2                      * Lnge addieren
dbra d1,putscr0
 move.l d2,d0                   * Lnge nach d0
 beq carset                     * Wenn Null, dann war Screen leer
 bsr.s einschub                 * Ram verschieben
 moveq #0,d1
putscr2:
 move d1,d0
 bsr.s zeiscrsp                 * Zeile in Speicher
 addq #1,d1
 cmp #24,d1                     * Bis letzte Zeile erreicht
 bne.s putscr2
rts

clrram:                         * a0 zeigt auf Quelle
 movea.l akttxt(a5),a1          * Ziel ist akttxt
clrram1:                        * Ende wird neu gesetzt
 move.b (a0)+,(a1)+
 bne.s clrram1
 subq.l #1,a1
 move.l a1,etxtxt(a5)           * Ende merken
rts

getzlen:                        * In d0.w steht Zeile
 movem.l a1-a2,-(a7)            * Ergebnis d0 Anzahl Zeichen
 bsr getline                    * a0 Adresse Zeile
 moveq #0,d0                    * Voreinstellung ist 0 Zeichen
 cmp.b #$7f,(a0)                * Ist erstes Zeichen '' ?
 beq.s getzlen3                 * Nein, dann weiter
 move.b (a1),d0                 * Anzahl der Zeichen holen
getzlen1:
 subq #1,d0                     * Genau auf letztes Zeichen
 bmi.s getzlen2                 * Wenn negativ dann kein Zeichen vorhanden
 cmp.b #' ',0(a0,d0.w)          * Leerzeichen am Ende einer Zeile entfernen
 beq.s getzlen1                 * Ja, Leerzeichen, weiter suchen
getzlen2:
 addq #1,d0                     * Ein Zeichen mehr, wegen subq vor der Abfrage
 move.b d0,(a1)                 * Neue Anzahl der Zeichen
 addq #2,d0                     * 2 Zeichen $d, $a
getzlen3:
 movem.l (a7)+,a1-a2
rts

getplatz:                       * Platz fr eine Zeile (d0) im Speicher schaffen
 bsr.s getzlen                  * d0 ist Nummer Zeile
 tst d0                         * Leerzeile
 beq carset                     * Ergebnis d0 Lnge der Zeile

einschub:                       * d0 = Lnge der Zeile
 movem.l a1-a2,-(a7)            * Es wird von akttxt an verschoben
 movea.l etxtxt(a5),a1
 add.l d0,etxtxt(a5)            * d0 zerstrt
 lea 1(a1,d0.l),a2              * Ziel+1 wegen -(an)
 move.l a1,d0
 sub.l akttxt(a5),d0            * Anzahl der zu verschiebenden Zeichen
 addq.l #1,a1                   * +1  wegen -(am)
einsch1:
 move.b -(a1),-(a2)             * Verschieben
dbra d0,einsch1                 * Schleife
 clr d0                         * $ffff, das durch dbra entstanden ist, lschen
 subq.l #1,d0                   * Obere Hlfte testen, wenn Null, dann OK
bpl.s einsch1                   * Sonst ist Text grer als 64 Kbyte
 movem.l (a7)+,a1-a2
rts

zeiscrsp:                       * Zeile vom Screen in den Speicher (d0=Nummer)
 bsr.s getzlen                  * Ziel ist akttxt (wird auch erhht)
 tst d0
 beq carset                     * Zeile leer
 movea.l akttxt(a5),a1          * d0,a0,a1 zerstrt
 subq #3,d0                     * Drei Zeichen weniger/ 2 fr $0d0a, 1 fr Dbra
 bmi.s zscrsp2                  * Negativ, dann nur $0d0a
zscrsp1:
 move.b (a0)+,(a1)+             * In Speicher
dbra d0,zscrsp1
zscrsp2:
 move.b #$0d,(a1)+
 move.b #$0a,(a1)+              * Endekennung einer Zeile
 move.l a1,akttxt(a5)           * akttxt aktualisieren
rts

zeispscr:                       * Zeile vom Speicher auf den Bildschirm
 movem.l d0-d2/a1-a3,-(a7)      * Ohne schieben
 movea.l a0,a3                  * a0 merken
 bsr getline                    * Zeileninfo holen
 moveq #0,d0                    * Zeichenzhler
 cmpa.l stxtxt(a5),a3           * Wenn vor Textanfang, dann ausgleichen
 bpl.s zspscr0
 addq.l #1,a3                   * Ausgleich
bra.s zspscr7                   * Zeiger fr Leerzeile
zspscr0:
 moveq #80-1,d0                 * d0 = Zeile
 moveq #' ',d1
zspscr1:                        * a0 ist Quelle
 cmp.b (a3),d1                  * Ergebnis a0 = Nchste Zeile
 bhi.s zspscr2                  * a0 nchste Zeile
 move.b (a3)+,(a0)+             * So lange holen, bis Controlzeichen erscheint
zspscr1a:
dbra d0,zspscr1                 * Prfen, ob Zeile voll ist
bra.s zspscr5
zspscr2:
 move.b (a3),d2                 * Null ist Ende
 beq.s zspscr5
 cmp.b #$d,d2                   * $d auch
 beq.s zspscr5
 addq.l #1,a3                   * Zeichen auf jeden Fall berspringen
 cmp.b #9,d2                    * TAB ?
 bne.s zspscr1                  * Nein, dann Zeichen ignorieren
 move.l d0,d2
 divu #8,d2
 swap d2                        * d1 = Anzahl der einzufgenden Leerzeichen
zspscr3:
 move.b #' ',(a0)+              * Leerzeichen einfgen
dbra d2,zspscr4                 * Prfen, ob Position erreicht
bra.s zspscr1a                  * JA !
zspscr4:
dbra d0,zspscr3                 * Prfen, ob Zeile voll ist
zspscr5:
 neg d0
 add #79,d0                     * Anzahl der Zeichen in dieser Zeile
zspscr6:
 tst.b (a3)                     * War es eine Null
 beq.s zspscr7                  * Ja, dann ist Zeile zu Ende
 cmp.b #$a,(a3)+                * Ist es $a ?
 bne.s zspscr6                  * Nein, dann bis $a suchen
bra.s zspscr8                   * Zeile ist zu Ende
zspscr7:
 tst d0                         * Anzahl der Zeichen gleich Null ?
 bne.s zspscr8                  * Nein, dann weiter
 move.b #$7f,(a0)               * Ja, Zeile ist leer
 addq #1,d0                     * Ein Zeichen mehr vorhanden
zspscr8:
 move.b d0,(a1)                 * Anzahl der Zeichen abspeichern
 movea.l a3,a0                  * a3 zurck
 movem.l (a7)+,d0-d2/a1-a3
rts

ptzurueck:                      * a0 zeigt auf Zeilenanfang
 subq.l #1,a0
 cmpa.l stxtxt(a5),a0           * a0 zeigt danach auf Anfang vorherige Zeile
 bmi carset                     * Bei Textanfang nur ein Zeichen abziehen
ptzur1:                         * und Carry setzen
 cmpa.l stxtxt(a5),a0           * Wenn auf Textanfang
 beq carres                     * Dann Ende
 cmp.b #$a,-(a0)                * Sonst bis Zeilenanfang suchen
 bne.s ptzur1
 addq.l #1,a0
bra carres                      * OK, nicht am Textanfang

screenup:
 btst.b #3,insl(a5)             * Scrollart
 bne screenue
 bsr page1clr
 movea.l akttxt(a5),a0
 movea.l a0,a2
 moveq #9-1,d0                  * 9 Zeilen aufwrts
screenua:
 bsr.s ptzurueck                * Eine Zeile zurck
 bcs.s screenub
 movea.l a0,a2                  * Merken, wenn nicht am Anfang
screenub:
 bsr zeispscr                   * Zeile in Bildschirmspeicher
 movea.l a2,a0
dbra d0,screenua
 movea.l akttxt(a5),a1
 move.l a0,akttxt(a5)           * Adresse merken
 movea.l a1,a0
 moveq #9,d0                    * Jetzt die restlichen Zeilen
screenuc:
 bsr zeispscr                   * Zeile in Bildschirmspeicher
 addq #1,d0
 cmp #24,d0                     * Bis alle Zeilen fertig
bne.s screenuc
screenud:                       * Einsprung screendown
 bsr clrram                     * Ram lschen
 move d7,d2
 clr d1
 bsr setpen                     * Wieder Position links oben
 bsr movetoo                    * Positionieren
 bsr prtall                     * Seite 1 neu beschreiben
 moveq #%00010000,d0            * Seite 0
 bsr setpage
 bsr clrinvis                   * Lschen
 clr d1
 move d7,d2
 bsr moveto                     * Positionieren
 bsr prtall                     * Ausgabe
bra crtstatus                   * Statuszeile

screenue:
 moveq #15-1,d1                 * Eine Seite weiter (Zeilenweise)
scrup0:                         * Einsprung crtup
 move.b cury(a5),-(a7)          * Retten
 move.b curx(a5),-(a7)
 clr.b curx(a5)
 move.b #23,cury(a5)            * Auf Anfang Zeile 23 positionieren
 moveq #0,d2
 move d1,d7
scrup1:
 move d1,d0
 bsr getzlen                    * Alle Zeichen zusammenzhlen
 add d0,d2
dbra d1,scrup1
 move.l d2,d0                   * Kein Zeichen
 beq.s scrup3                   * Ja, dann weiter
 bsr einschub                   * Sonst Einfgen
 move d7,d1                     * Anzahl der Durchlufe
scrup2:
 move d7,d0
 sub d1,d0                      * Alle Zeilen in den Speicher
 bsr zeiscrsp
dbra d1,scrup2
scrup3:
 movea.l akttxt(a5),a0
scrup4:
 bsr scroll                     * Scrollen auf dem Bildschirm
 moveq #23,d0
 bsr zeispscr                   * Letzte Zeile vom Speicher auf den Bildschirm
 bsr lineaus
dbra d7,scrup4
 move.b (a7)+,curx(a5)          * Position zurck
 move.b (a7)+,cury(a5)
 bsr clrram                     * Ram lschen
bra crtstatus                   * Statuszeile neu

crtup:                          * Scroll umm eine Zeile
 moveq #1-1,d1
bra.s scrup0

screendown:
 btst.b #3,insl(a5)             * Scrollart
 bne.s screendd
 move.l akttxt(a5),-(a7)
 bsr page1clr
 movea.l (a7),a0
 movea.l a0,a2
 moveq #15-1,d0                 * 15 Zeilen aufwrts
screenda:
 bsr ptzurueck                  * Eine Zeile zurck
 bcs.s screendb
 movea.l a0,a2                  * Merken, wenn nicht am Anfang
screendb:
 bsr zeispscr                   * Zeile in Bildschirmspeicher
 movea.l a2,a0
dbra d0,screenda
 move.l a0,akttxt(a5)
 movea.l (a7)+,a0
 moveq #15,d0                   * Jetzt die restlichen Zeilen
screendc:
 bsr zeispscr                   * Zeile in Bildschirmspeicher
 addq #1,d0
 cmp #24,d0                     * Bis alle Zeilen fertig
bne.s screendc
bra screenud                    * Rest des Bildschirms aufbauen

screendd:
 moveq #15-1,d1                 * Eine Seite scrollen (Zeilenweise)
scrdown0:
 move.b cury(a5),-(a7)
 move.b curx(a5),-(a7)          * Retten
 clr.b cury(a5)                 * Auf Zeile Null
 moveq #0,d2                    * Zeichenzhler
 move d1,d7                     * Anzahl der Scrolldurchgnge merken
scrdown1:
 moveq #23,d0
 sub d1,d0                      * Zeile berechnen
 bsr getzlen                    * Zeilenlnge holen
 add d0,d2                      * Zeichen zusammenzhlen
dbra d1,scrdown1                * Nchste Zeile
 move.l akttxt(a5),-(a7)
 move.l d2,d0
 beq.s scrdown3                 * Kein Zeichen, dann weiter
 bsr einschub                   * Einfgen
 move d7,d1
scrdown2:
 moveq #23,d0
 sub d1,d0
 bsr zeiscrsp                   * Alle Zeilen vom Bildschirm in den Speicher
dbra d1,scrdown2
scrdown3:
 move.l (a7),akttxt(a5)
scrdown4:
 bsr insline                    * Oberste Zeile einfgen
 movea.l akttxt(a5),a0
 bsr ptzurueck                  * Pointer eine Zeile zurck
 bcs.s scrdown5
 move.l a0,akttxt(a5)           * Wenn nicht vor Textanfang neue Adresse merken
scrdown5:
 moveq #0,d0
 bsr zeispscr                   * Zeile vom Speicher auf den Bilschirm
 bsr.s lineaus
dbra d7,scrdown4
 movea.l (a7)+,a0
 move.b (a7)+,curx(a5)
 move.b (a7)+,cury(a5)          * Zurck
 bsr clrram                     * Ram lschen
bra crtstatus                   * Statuszeile neu

crtdown:
 moveq #1-1,d1                  * Eine Zeile scrollen
bra.s scrdown0

page1clr:
 bsr putscreen
 bsr homepos                    * Position links oben
 move d2,d7
 moveq #%01000000,d0
 bsr setpage                    * Seite 1
 bsr movetoo                    * Positionieren
 bsr erapen
 bsr prtall                     * Lschen, was dort stand
bra clrscr                      * Bildschirmspeicher lschen

lineaus:                        * Eine Zeile auf beiden Seiten ausgeben
 bsr seite1                     * Seite 1
 bsr setpen                     * Auf Schreiben
 bsr prtline                    * Ausgabe
 bsr seite0                     * Seite 0
bra prtline                     * Ausgabe

crtstatus:                      * Statuszeile ausgeben
 lea crtsttxt(pc),a0            * Text
 lea einbuf+40(a5),a1           * Ziel
crtst1:
 move.b (a0)+,(a1)+             * bertragen
 bne.s crtst1
 lea einbuf+40+8(a5),a0         * Startadresse
 move.l stxtxt(a5),d0
 bsr print6x                    * Einsetzen
 move.b #' ',(a0)               * Null berschreiben
 lea einbuf+40+26(a5),a0        * Anfangsadresse Ziel
 move.l akttxt(a5),d0
 bsr print6x                    * Einsetzen
 move.b #' ',(a0)               * Null berschreiben
 lea einbuf+40+40(a5),a0        * Endadresse Editor
 move.l etxtxt(a5),d0
 bsr print6x                    * Einsetzen
 move.b #' ',(a0)               * Null berschreiben
 btst.b #0,insl(a5)             * Einfgemodus an ?
 beq.s crtst2                   * Nein, weiter
 move.l #'einf',einbuf+40+48(a5)
crtst2:
 tst.b optflag(a5)              * Amerikanischer Zeichensatz ?
 beq.s crtst3                   * Ja, weiter
 cmp.b #1,optflag(a5)           * Deutscher Zeichensatz?
 bne.s crtst2a                  * nein, dann User Zeichensatz
 move.l #'DE  ',einbuf+40+54(a5)
 bra.s crtst3
crtst2a:
 move.l fontname(a5),einbuf+40+54(a5)
crtst3:
 btst.b #3,insl(a5)             * Scrollart
 beq.s crtst4                   * Seitenweise, dann weiter
 move.b #'Z',einbuf+40+70(a5)
crtst4:
 btst.b #4,insl(a5)             * Auf Zeilenanfang / Auf Textanfang
 beq.s crtst5
 move.l #'Auto',einbuf+40+60(a5)* Auf Textanfang
crtst5:
 lea einbuf+40(a5),a0
 moveq #$11,d0
 moveq #2,d1
 moveq #2,d2
 moveq #84,d3                   * Umrandung um 84 Zeichen
 bsr textaus                    * Und Text ausgeben
 bsr    umrande
 moveq  #0,d6
 move.b groesse(a5),d6
 lsr    #4,d6                   * Nur Gre-X
 mulu   #6,d6                   * Abstand zwischen zwei Zeichen
 bsr.s  tabsaus
 eori.b #1,wrtpage(a5)          * Andere Seite auch
 bsr aktpage
 moveq #$11,d0                  * Gre neu einstellen
 moveq #2,d1
 moveq #2,d2
 bsr umrande
 bsr textaus                    * Und neu ausgeben

tabsaus:                        * Anzeige der Tabs
 move.w d6,d1
 lsr    #1,d1
 subq   #1,d1                   * Anfangsposition X
 moveq  #12,d2                  * Y-Position
 lea    edittabs(a5),a1         * Tab-Feld
 moveq  #80-1,d0
tabsaus0:
 tst.b  (a1)+
 bpl.s  tabsaus1                * Bit nicht gesetzt => Kein Tab
 bsr    moveto                  * Positionieren
 move.b #%10001010,gdp.w        * Kleiner Strich zum Anzeigen
tabsaus1:
 add    d6,d1
 cmp    #510,d1                 * Auerhalb des Bildschirms ?
dbhi    d0,tabsaus0             * Weiter, wenn nicht Position 80 und noch im
tabsaus2:                       * Bildschirmbereich
rts

editzahl:                       * Zahl einlesen
 bsr.s editabuf                 * ASCII-Zeichen holen
 bsr.s edits1buf                * Alte Seite
 movea.l a1,a0                  * Adresse nach a0
bra wertmfeh                    * Wert holen

editebuf:                       * Eingabe mit Bildschirm anschalten
 moveq #%10100000,d0
 bsr setpage
 bsr.s editbuf1
edits1buf:
 move.b #10,flip(a5)            * Original-Seite einschalten
 move.b #1,curon(a5)
 bsr    aktpage
 move.b groesse(a5),gdp+3*cpu.w * Vorsichtshalber richtige Gre einstellen
rts
                                * Eingabe mit Screen ausschalten
editabuf:                       * a0 = Adresse Text
 lea    einbuf+90(a5),a1
 moveq  #125,d2
editab0:                        * Einsprung
 moveq #%10000000,d0            * a1 Adresse Ziel
 bsr setpage                    * Ziel ist einbuf+40
 bsr clrinvis                   * d2 ist Hhe
editbuf1:                       * d3 ist Anzahl Zeichen
 clr.b flip(a5)                 * Keine Seitenumschaltung
 moveq #5,d1
 moveq #$33,d0
 bsr textprint                  * Text ausgeben
 sub #30,d2
 movea.l a1,a0
 moveq #%10100000,d0
 bsr setpage                    * Seite 2 ist jetzt Lese- und Schreibseite
 moveq #$22,d0
 moveq #40,d3
 bsr textein                    * Text holen
 bcs carset                     * Abbruch
 tst d4
 beq carset                     * Kein Zeichen, dann Fehler
 movea.l a1,a0
bra carres                      * Sonst OK

editci:                         * Zeichen von Tastatur ohne Seitenumschaltung
 clr.b flip(a5)                 * Flip aus
 clr.b curon(a5)                * Cursor aus
 bsr ci                         * Zeichen holen
 move.b #10,flip(a5)            * Flip an
 move.b #1,curon(a5)            * Cursor an
rts

sucherse:                       * String suchen und auf Abfrage ersetzen
 bsr.s suchedit                 * Suchen
 bcs.s  suchersfi
 bsr ki                         * Tastaturabfrage
 cmp.b #'J',d0
 beq.s ersetze                  * Ersetzen
 cmp.b #'N',d0
 beq.s  sucherse                * Weitersuchen
suchersfi:                      * Ende bei falscher Eingabe oder wenn nicht mehr
rts                             * gefunden

ersetze:                        * String ersetzen
 move.b d1,curx(a5)             * Dort fngt String an
 lea ausbuf(a5),a0
ersetze1:
 tst.b (a0)+                    * Anzahl Zeichen
 beq.s ersetze2
 bsr delchar                    * Lschen
bra.s ersetze1
ersetze2:
 lea ausbuf+42(a5),a0
ersetze3:
 move.b (a0)+,d0                * Zeichen holen
 beq.s sucherse                 * Weitersuchen
 bsr inschar                    * Einfgen
 move.l a0,-(a7)
 bsr charoscr                   * Ausgeben
 movea.l (a7)+,a0
bra.s ersetze3

suchedit:
 move.b curx(a5),-(a7)          * Wenn nicht gefunden, dann an aktueller Stelle
 move.b cury(a5),-(a7)          * bleiben
 bsr.s suchscr                  * Nur innerhalb des Screens suchen
 bcs.s suched1
 addq.l #4,a7                   * Ergebnis curx hinter Wort
 cmp.b #23,cury(a5)
 bne    carres                  * OK
 move.b d1,-(a7)
 bsr    editctz                 * Cursor nicht auf letzte Zeile
 move.b (a7)+,d1
bra carres
suched1:
 bsr.s suchram                  * Im Ram hinter Screen suchen
 bcs.s suched2                  * a0 ist Ergebnis
 move.l akttxt(a5),-(a7)
 move.l a0,-(a7)
 bsr putscreen                  * Screen im Ram ablegen
 movea.l akttxt(a5),a0
 adda.l (a7)+,a0                * Neue Adresse
 suba.l (a7)+,a0
 addq.l #1,a0
 bsr ptzurueck                  * Auf Anfang der Zeile
 move.l a0,akttxt(a5)
 bsr getscreen                  * Screen holen
 addq.l #4,a7                   * Stack reinigen
bra.s suchedit                  * Neu suchen
suched2:
 move.b (a7)+,cury(a5)
 move.b (a7)+,curx(a5)
bra carset                      * Nicht gefunden

suchscr:
 bsr calccur                    * Zeileninfo
 lea ausbuf(a5),a0
 move.b curx(a5),d0
suchscr1:
 cmpm.b (a2)+,(a0)+             * Suchen
 bne.s suchscr2
 addq.b #1,d0                   * Gefunden, dann nchstes Zeichen
 tst.b (a0)                     * Ende String ?
 beq.s  tstcurend               * Dann gefunden
 cmp.b (a1),d0
 bcs.s suchscr1                 * Weitersuchen

suchscr2:
 addq.b #1,curx(a5)             * Nchste Position
 move.b curx(a5),d1
 cmp.b (a1),d1
 bcs.s suchscr                  * Weitersuchen
 move.b lrand(a5),curx(a5)      * Neue
 addq.b #1,cury(a5)             * Zeile
 cmp.b #24,cury(a5)             * Auf letzter Zeile
 bne.s suchscr                  * Nein, dann weitersuchen
bra carset                      * Ende, nicht gefunden

suchram:                        * Im Ram suchen
 movea.l akttxt(a5),a0
suchram0:
 tst.b (a0)                     * Nicht gefunden
 beq carset
 movea.l a0,a2
 lea ausbuf(a5),a1
suchram1:
 move.b (a1)+,d0                * OK, gefunden
 beq.s  suchram3
 cmp.b (a2)+,d0                 * Vergleich
 beq.s suchram1                 * Gleich, also weitersuchen
suchram2:
 addq.l #1,a0                   * Neue Adresse
bra.s suchram0                  * Neu suchen
suchram3:
 move.b lrand(a5),d0            * Linker Rand
 beq    carres
 movea.l a0,a1
suchram4:
 cmp.b  #$0a,-(a1)              * Ende der letzten Zeile suchen
 beq.s  suchram2                * Gefunden, deshalb Cursor vor linkem Rand
 cmpa.l akttxt(a5),a1
 bmi.s  suchram2                * Vor Textanfang
 subq.b #1,d0
 bne.s  suchram4                * Ende der letzten Zeile suchen
bra     carres                  * OK, Cursor ist hinter linkem Rand

tstcurend:
 move.b curx(a5),d1             * Gefundener String
 move.b d0,curx(a5)             * Cursor dahinter
 cmp.b  #80,d0                  * Cursor auf Position 80 ?
 bcs    carres                  * Nein, dann weiter
 move.b #79,curx(a5)            * Nur bis 79 ist erlaubt
bra     carres

editadr:                        * Adresse der Cursorposition holen, wenn Screen
 movem.l d0-d2,-(a7)            * im Speicher wre
 moveq #0,d1
 moveq #0,d2
editadr1:
 cmp.b cury(a5),d1              * Wenn Cursorzeile erreicht ist, dann weiter
 beq.s editadr2                 * Ja, weiter
 move d1,d0                     * Zeile
 bsr getzlen                    * Zeileninfo holen
 add d0,d2                      * Zeichenzahl addieren
 addq #1,d1                     * Nchste Zeile
bra.s editadr1                  * Schleife
editadr2:
 bsr calccur                    * Cursorposition holen
 cmp.b #$7f,(a0)
 beq.s editadr3                 * Bei Leerzeile weiter
 move.b d1,d0
 bsr getzlen                    * Wirkliche Zeilenlnge holen
 subq #2,d0                     * CR LF weg
 move.b curx(a5),d1
 add d1,d2
 cmp.b d0,d1                    * Cursor hinter Zeilenende ?
 bmi.s editadr3                 * Nein, weiter
 move.b #blkins,(a2)            * 'blkins' in Speicher als Endemarke der Zeile,
                                * da Leerzeichen am Ende gelscht wrden und
                                * der neue Text dann an eine falsche Stelle kme
 addq.b #1,d1                   * Anzahl der Zeichen erhhen
 move.b d1,(a1)                 * Ablage
editadr3:                       * 'blkins' wird automatisch wieder gelscht
 movea.l d2,a3                  * Anzahl der Zeichen nach a3
 adda.l akttxt(a5),a3           * Anfang des Screen-Bereichs addieren
 movem.l (a7)+,d0-d2            * a3 ist jetzt Adresse der Cursorposition nach
rts                             * Aufruf von PUTSCREEN

getblock:                       * Blockadressen suchen
 lea $ffff.w,a1                 * Kein Blockanfang
 movea.l stxtxt(a5),a0          * Von Anfang an
getblk1:
 move.b (a0)+,d0                * Zeichen holen
 beq carset                     * Null ist Ende und Fehler
 bpl.s getblk1                  * Positiv, dann weiter
 cmp.b #blkstart,d0             * Blockstart ?
 beq.s getblk2                  * Ja
 cmp.b #blkende,d0              * Blockende ?
 bne.s getblk1                  * Nein
 lea -1(a0),a2                  * a2 ist Blockende
 cmpa.l a1,a2                   * Blockende mu hinter Blockanfang liegen
 bhi carres                     * OK
bra carset                      * Fehler
getblk2:
 lea -1(a0),a1                  * a1 ist Blockanfang
bra.s getblk1

markeweg:                       * Marken entfernen
 move.b insl(a5),d0             * Sind Marken markiert ?
 and.b #%110,d0
 beq carres                     * Nein, Ende
 move.b cury(a5),-(a7)
 move.b curx(a5),-(a7)
 moveq #24-1,d1                 * Alle Zeilen durchtesten
mark0weg:
 move.b d1,cury(a5)             * Zeilennummer
 bsr calccur                    * Zeileninfo holen
 clr.b curx(a5)                 * Auf Zeichen Null
mark1weg:
 move.b (a0)+,d0                * Zeichen holen
 bpl.s mark3weg
 cmp.b #blkstart,d0             * Blockstart ?
 beq.s mark2weg                 * Ja
 cmp.b #blkende,d0              * Blockende ?
 bne.s mark3weg                 * Nein, weiter
mark2weg:
 bsr delchar                    * Zeichen entfernen
 subq.l #1,a0                   * Weitersuchen
bra.s mark1weg
mark3weg:
 addq.b #1,curx(a5)             * Cursor weiter
 move.b curx(a5),d0
 cmp.b (a1),d0                  * Hinter letztem Zeichen ?
 bmi.s mark1weg                 * Nein, wiederholen
dbra d1,mark0weg                * Nchste Zeile
 move.b (a7)+,curx(a5)
 move.b (a7)+,cury(a5)

markrweg:                       * Marken im Ram entfernen
 move.b insl(a5),d0
 and.b #%110,d0
 beq carres                     * Keine Marken vorhanden
 and.b #%11111001,insl(a5)      * Merker, da alle entfernt sind
 movea.l stxtxt(a5),a0          * Anfangsadresse
mark4weg:
 move.b (a0)+,d0                * Zeichen holen
 beq carres                     * Ende
 bpl.s mark4weg                 * Keine Marke
 cmp.b #blkstart,d0
 beq.s mark5weg                 * Blockstart
 cmp.b #blkende,d0
 bne.s mark4weg                 * Keine Marke
mark5weg:
 movea.l a0,a2                  * Adresse nach a2
 lea -1(a0),a1                  * Zieladresse
mark6weg:
 move.b (a2)+,(a1)+             * Bis Null bertragen
 bne.s mark6weg
 subq.l #1,etxtxt(a5)           * Endemerker erniedrigen
 cmpa.l akttxt(a5),a0           * Lag Marke hinter Screen ?
 bpl.s mark4weg                 * Nein, Schleife fortfhren
 subq.l #1,akttxt(a5)           * akttxt erniedrigen, da gelschtes Byte vor
bra.s mark4weg                  * Screen-Bereich lag

helptxt0:
 dc.b 'Editorfunktionen ',0

helptxt1:
 dc.b   '^E = Zeile hoch',10
 dc.b   '^X = Zeile runter',10
 dc.b   '^S = Zeichen links',10
 dc.b   '^D = Zeichen rechts',10
 dc.b   '^A = Wort links',10
 dc.b   '^F = Wort rechts',10
 dc.b   '^Z = Zeile auf',10
 dc.b   '^W = Zeile ab',10
 dc.b   '^C = Seite vor',10
 dc.b   '^R = Seite zurck',10
 dc.b   '^Y = Zeile lschen',10
 dc.b   '^N = Zeile einfgen',10
 dc.b   '^G = Zeichen lschen',10
 dc.b   '^U = Zeichen einfgen',10
 dc.b   '^T = Lschen rechts',10
 dc.b   '^I = Auf Tab rechts',10
 dc.b   '^O = Auf Tab links',10
 dc.b   '^L = Suchen wiederholen',10
 dc.b   10
 dc.b   '^V = Einfgemode',10
 dc.b   '^P = Zeichensatz',0

helptxt2:
 dc.b   '^KB = Block Anfang',10
 dc.b   '^KK = Block Ende',10
 dc.b   '^KH = Marken lschen',10
 dc.b   '^KY = Block lschen',10
 dc.b   '^KV = Block verschieben',10
 dc.b   '^KC = Block kopieren',10
 dc.b   '^KR = Block lesen',10
 dc.b   '^KW = Block schreiben',10
 dc.b   '^KD = Block drucken',10
 dc.b   '^KS = Block auf Disk',10
 dc.b   '^KL = Block von Disk',10
 dc.b   '^KT = Text auf Disk',10
 dc.b   '^KI = Inhalt der Disk',10
 dc.b   '^KF = Editordaten speichern',10
 dc.b   '^KG = Editordaten laden',10
 dc.b   '^KP = Schriftart laden',10
 dc.b   '^KX = Ende (^KQ)',10
 dc.b   '^KA = Assembler',0

helptxt3:
 dc.b   '^QR = An Textanfang',10
 dc.b   '^QC = An Textende',10
 dc.b   '^QE = Oberste Zeile',10
 dc.b   '^QX = Unterste Zeile',10
 dc.b   '^QS = An Zeilenanfang',10
 dc.b   '^QD = An Zeilenende',10
 dc.b   '^QF = Suchen (^L)',10
 dc.b   '^QA = Ersetzen (^L)',10
 dc.b   '^QT = Zeile trennen',10
 dc.b   '^QV = Zeile verschmelzen',10
 dc.b   10
 dc.b   'ESC A = Alter Text',10
 dc.b   'ESC N = Neuer Text',10
 dc.b   'ESC I = Init Tabs',10
 dc.b   'ESC C = Lschen Tabs',10
 dc.b   'ESC W = Tab an/aus',10
 dc.b   'ESC P = Ausdruck mit',10
 dc.b   'ESC O = Ausdruck ohne',10
 dc.b   'ESC L = Linker Rand',10
 dc.b   'ESC T = Autotab',10
 dc.b   'ESC S = Scrollart',10
 dc.b   'ESC D = Definiere Macro',10
 dc.b   'ESC M = Init Macros',10
 dc.b   'ESC 0-9 = Macrofunktionen',0

macrotxt:
 dc.b   'move',0
 dc.b   'clr',0
 dc.b   'add',0
 dc.b   'sub',0
 dc.b   'bsr',0
 dc.b   'bra',0
 dc.b   'dbra',0
 dc.b   'tst',0
 dc.b   'trap',0
 dc.b   'rts',0

macrtxt0:
 dc.b   'Bitte Nummer (0-9) whlen',0

macrtxt1:
 dc.b   'Neuer Macrotext',0

crtsttxt:
 dc.b 'Start= $        Fenster= $        Tor= $              US        '
 dc.b '      S CTRL-J=Hilfe',0

sutxt:
 dc.b 'Suche',0

ertxt:
 dc.b 'Ersetze',0

nametxt1:
kopdt2:
 dc.b 'Name '

zieltxt:
 dc.b 'Ziel',0

nametxt2:
kopdt1:
 dc.b 'Name '

quelltxt:
 dc.b 'Quelle',0

werttxt:
 dc.b 'Wert',0

disktxt:
inhdt1:
 dc.b 'Laufwerk und Dateiauswahl',0

 ds 0

                                                                                                  ichen

editctv:                        * Ctrl-V
 eori.b #1,insl(a5)             * Einfgemode umschalten
bra crtstatus                   * Statuszeile neu ausgeben

editctw:                        * Ctrl-W
 bsr crtdown                    * Immer Scrollen
 cmp.b #22,cury(a5)             * Ist Cursor am untersten Rand angelangt ?
 bcc.s editctw0                 * Ja, dann Ende
 addq.b #1,cury(a5)             * Sonst Cursor runter
editctw0:
rts

editctx:                        * Ctrl-X
 cmp.b #2